﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0079_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

$GoogleChromeRegPath = "HKLM:\Software\Policies\Google\Chrome"
$HistorySearchSettingsKey = "HistorySearchSettings"
$HistorySearchSettingsValue = 2
if(!(Test-Path $GoogleChromeRegPath)){
    Log-Message -message "$GoogleChromeRegPath registry path not found"
    New-Item -Path $GoogleChromeRegPath -Force | Out-Null
    Log-Message -message "$GoogleChromeRegPath registry path created"
    New-ItemProperty -Path $GoogleChromeRegPath -Name $HistorySearchSettingsKey -Value $HistorySearchSettingsValue -PropertyType DWORD -Force | Out-Null
    Log-Message -message "$HistorySearchSettingsKey registry key created value $HistorySearchSettingsValue "
} else {
    Log-Message -message "Checking value of $HistorySearchSettingsKey registry key expecting $HistorySearchSettingsValue"
    Try {
        $HistorySearchSettingsCheck = Get-ItemPropertyValue -Path $GoogleChromeRegPath -Name $HistorySearchSettingsKey
        if($HistorySearchSettingsCheck -ne $HistorySearchSettingsValue){
            Log-Message -message "$HistorySearchSettingsKey configured incorrect value: $HistorySearchSettingsCheck"
            New-ItemProperty -Path $GoogleChromeRegPath -Name $HistorySearchSettingsKey -Value $HistorySearchSettingsValue -PropertyType DWORD -Force | Out-Null
            Log-Message -message "Set $HistorySearchSettingsKey value: $HistorySearchSettingsValue"

        } else {
            Log-Message -message "$HistorySearchSettingsKey properly configued. No changes needed"
        }
    } Catch {
        Log-Message -message "The property does not exist or an error occurred: $_"
        New-ItemProperty -Path $GoogleChromeRegPath -Name $HistorySearchSettingsKey -Value $HistorySearchSettingsValue -PropertyType DWORD -Force | Out-Null
        Log-Message -message "Set $HistorySearchSettingsKey value: $HistorySearchSettingsValue"
    }
}